/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Application.Fenetre;
import Application.FractalesControleur;
import Application.FractalesModele;
import Application.typeFractale;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;

public class FractalesVue
extends JComponent
implements Observer,
MouseWheelListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private FractalesControleur controleur;
    private FractalesModele model;
    private float x1debut;
    private float x2debut;
    private float y1debut;
    private float y2debut;
    Image img;
    BufferedImage bufferedImage = new BufferedImage(961, 880, 1);
    Graphics g = this.bufferedImage.getGraphics();

    public FractalesVue(FractalesControleur controleur, FractalesModele modele) {
        this.controleur = controleur;
        this.model = modele;
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics g) {
        this.img = this.createImage();
        g.drawImage(this.img, 0, 0, this);
    }

    public Image createImage() {
        float x1 = this.model.getx1();
        float x2 = this.model.getx2();
        float y1 = this.model.gety1();
        float y2 = this.model.gety2();
        float y = this.model.gety();
        float zoom = this.model.getZoom();
        int iteration_max = this.model.getIteration_max();
        float image_x = (x2 - x1) * zoom;
        float image_y = (y2 - y1) * zoom;
        int x = 0;
        while ((float)x < image_x) {
            float i = this.controleur.fractale(x, (int)y);
            if (this.model.type == typeFractale.NEWTON) {
                this.g.setColor(Color.BLACK);
                this.g.drawLine(x, (int)y, x + 1, (int)y + 1);
                ((Graphics2D)this.g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.g.setColor(Color.getHSBColor(1.0f, 255.0f, i * zoom / (float)iteration_max));
                this.g.drawLine(x, (int)y, x + 1, (int)y + 1);
            } else if (i == (float)iteration_max) {
                this.g.setColor(Color.BLACK);
                this.g.drawLine(x, (int)y, x + 1, (int)y + 1);
                ((Graphics2D)this.g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                this.g.setColor(Color.getHSBColor(1.0f, 255.0f, i * zoom / (float)iteration_max));
                this.g.drawLine(x, (int)y, x + 1, (int)y + 1);
                ((Graphics2D)this.g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            ++x;
        }
        if (this.model.gety() < image_y) {
            this.model.sety(this.model.gety() + 1.0f);
            this.repaint();
        }
        return this.bufferedImage;
    }

    public static void main(String[] args) {
        FractalesModele mod\u00e8le = new FractalesModele(-2.1f, 0.6f, -1.2f, 1.2f, typeFractale.MANDELBROT);
        FractalesControleur controller = new FractalesControleur(mod\u00e8le);
        FractalesVue view = new FractalesVue(controller, mod\u00e8le);
        Fenetre fen = new Fenetre("Fractales", view, mod\u00e8le);
        fen.add(view);
        mod\u00e8le.addObserver(view);
        view.repaint();
        fen.setSize(960, 880);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        float x1 = this.model.getx1();
        float x2 = this.model.getx2();
        float alphax = (x2 - x1) / 961.0f;
        float xp = (float)MouseInfo.getPointerInfo().getLocation().x * alphax + x1;
        float xdif = Math.abs(x1 - x2) / 2.0f;
        float y1 = this.model.gety1();
        float y2 = this.model.gety2();
        float alphay = (y2 - y1) / 880.0f;
        float yp = (float)MouseInfo.getPointerInfo().getLocation().y * alphay + y1;
        float ydif = Math.abs(y1 - y2) / 2.0f;
        if (e.getWheelRotation() < 0) {
            this.model.setx1(xp - xdif / 2.0f);
            this.model.setx2(xp + xdif / 2.0f);
            this.model.sety1(yp - ydif / 2.0f);
            this.model.sety2(yp + ydif / 2.0f);
            this.model.setZoom(this.model.getZoom() * 2.0f);
            this.model.setIteration_max((int)((double)this.model.getIteration_max() * 1.3));
        } else {
            this.model.setx1(xp - xdif * 2.0f);
            this.model.setx2(xp + xdif * 2.0f);
            this.model.sety1(yp - ydif * 2.0f);
            this.model.sety2(yp + ydif * 2.0f);
            this.model.setZoom(this.model.getZoom() / 2.0f);
            this.model.setIteration_max((int)((double)this.model.getIteration_max() / 1.3));
        }
        this.model.sety(0.0f);
        this.createImage();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage image = this.model.getImage();
        int w = Math.min(image.getWidth(), this.getWidth());
        int h = Math.min(image.getHeight(), this.getHeight());
        g.drawImage(image, 0, 0, w, h, 0, 0, w, h, null);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        float x1 = this.model.getx1();
        float x2 = this.model.getx2();
        float alphax = (x2 - x1) / 961.0f;
        float xp = (float)MouseInfo.getPointerInfo().getLocation().x * alphax + x1;
        float xdif = Math.abs(x1 - x2) / 2.0f;
        float y1 = this.model.gety1();
        float y2 = this.model.gety2();
        float alphay = (y2 - y1) / 880.0f;
        float yp = (float)MouseInfo.getPointerInfo().getLocation().y * alphay + y1;
        float ydif = Math.abs(y1 - y2) / 2.0f;
        this.x1debut = xp - xdif;
        this.x2debut = xp + xdif;
        this.y1debut = yp - ydif;
        this.y2debut = yp + ydif;
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        float x1 = this.model.getx1();
        float x2 = this.model.getx2();
        float alphax = (x2 - x1) / 961.0f;
        float xp = (float)MouseInfo.getPointerInfo().getLocation().x * alphax + x1;
        float xdif = Math.abs(x1 - x2) / 2.0f;
        float y1 = this.model.gety1();
        float y2 = this.model.gety2();
        float alphay = (y2 - y1) / 880.0f;
        float yp = (float)MouseInfo.getPointerInfo().getLocation().y * alphay + y1;
        float ydif = Math.abs(y1 - y2) / 2.0f;
        float x1fin = xp - xdif;
        float x2fin = xp + xdif;
        float y1fin = yp - ydif;
        float y2fin = yp + ydif;
        this.model.setx1(this.model.getx1() + this.x1debut - x1fin);
        this.model.setx2(this.model.getx2() + this.x2debut - x2fin);
        this.model.sety1(this.model.gety1() + this.y1debut - y1fin);
        this.model.sety2(this.model.gety2() + this.y2debut - y2fin);
        this.model.sety(this.model.gety1());
        this.createImage();
    }
}

