/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Application.FractalesModele;
import Application.FractalesVue;
import Application.typeFractale;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class Fenetre
extends JFrame
implements ActionListener {
    private JMenuBar menuBar = new JMenuBar();
    public JMenu fractale = new JMenu("Fractale");
    public JMenu zoom = new JMenu("Zoom");
    public JMenu iterations = new JMenu("It\u00e9rations");
    public JMenuItem mandelbrotMenu = new JMenuItem("MandelBrot");
    public JMenuItem juliaMenu = new JMenuItem("Julia");
    public JMenuItem newtonMenu = new JMenuItem("Newton");
    public JMenuItem zoomer = new JMenuItem("Zommer");
    public JMenuItem dezoomer = new JMenuItem("D\u00e9zoomer");
    public JMenuItem augmenterIt\u00e9rations = new JMenuItem("It\u00e9rations *2");
    public JMenuItem diminuerIt\u00e9rations = new JMenuItem("It\u00e9rations /2");
    private FractalesModele m;
    private FractalesVue v;
    private static final long serialVersionUID = 1L;

    public Fenetre(String titre, FractalesVue vue, FractalesModele mod\u00e8le) {
        this.setBounds(10, 0, 961, 880);
        this.setTitle("Fractales - Baum\u00e9,Lapicardise - S3B");
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.v = vue;
        this.m = mod\u00e8le;
        this.fractale.add(this.mandelbrotMenu);
        this.fractale.add(this.juliaMenu);
        this.fractale.add(this.newtonMenu);
        this.zoom.add(this.zoomer);
        this.zoom.add(this.dezoomer);
        this.iterations.add(this.augmenterIt\u00e9rations);
        this.iterations.add(this.diminuerIt\u00e9rations);
        this.menuBar.add(this.fractale);
        this.menuBar.add(this.zoom);
        this.menuBar.add(this.iterations);
        this.setJMenuBar(this.menuBar);
        this.mandelbrotMenu.addActionListener(this);
        this.juliaMenu.addActionListener(this);
        this.newtonMenu.addActionListener(this);
        this.zoomer.addActionListener(this);
        this.dezoomer.addActionListener(this);
        this.augmenterIt\u00e9rations.addActionListener(this);
        this.diminuerIt\u00e9rations.addActionListener(this);
        this.augmenterIt\u00e9rations.setAccelerator(KeyStroke.getKeyStroke(38, 2));
        this.diminuerIt\u00e9rations.setAccelerator(KeyStroke.getKeyStroke(40, 2));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        float x1 = this.m.getx1();
        float x2 = this.m.getx2();
        float alphax = (x2 - x1) / 961.0f;
        float xp = 480.0f * alphax + x1;
        float xdif = Math.abs(x1 - x2) / 2.0f;
        float y1 = this.m.gety1();
        float y2 = this.m.gety2();
        float alphay = (y2 - y1) / 880.0f;
        float yp = 440.0f * alphay + y1;
        float ydif = Math.abs(y1 - y2) / 2.0f;
        if (arg0.getSource() == this.mandelbrotMenu) {
            this.m.type = typeFractale.MANDELBROT;
            this.m.setZoom(350.0f);
            this.m.setIteration_max(75);
            this.m.setx1(-2.1f);
            this.m.setx2(0.6f);
            this.m.sety1(-1.2f);
            this.m.sety2(1.2f);
        } else if (arg0.getSource() == this.juliaMenu) {
            this.m.type = typeFractale.JULIA;
            this.m.setZoom(350.0f);
            this.m.setIteration_max(75);
            this.m.setx1(-1.4f);
            this.m.setx2(1.6f);
            this.m.sety1(-1.2f);
            this.m.sety2(2.2f);
        } else if (arg0.getSource() == this.newtonMenu) {
            this.m.type = typeFractale.NEWTON;
            this.m.setZoom(350.0f);
            this.m.setIteration_max(75);
            this.m.setx1(-1.4f);
            this.m.setx2(1.6f);
            this.m.sety1(-1.2f);
            this.m.sety2(2.2f);
        } else if (arg0.getSource() == this.zoomer) {
            this.m.setx1(xp - xdif / 2.0f);
            this.m.setx2(xp + xdif / 2.0f);
            this.m.sety1(yp - ydif / 2.0f);
            this.m.sety2(yp + ydif / 2.0f);
            this.m.setZoom(this.m.getZoom() * 2.0f + 1.0f);
            this.m.setIteration_max((int)((double)this.m.getIteration_max() * 1.3));
        } else if (arg0.getSource() == this.dezoomer) {
            this.m.setx1(xp - xdif * 2.0f);
            this.m.setx2(xp + xdif * 2.0f);
            this.m.sety1(yp - ydif * 2.0f);
            this.m.sety2(yp + ydif * 2.0f);
            this.m.setZoom(this.m.getZoom() / 2.0f + 1.0f);
            this.m.setIteration_max((int)((double)this.m.getIteration_max() / 1.3));
        } else if (arg0.getSource() == this.augmenterIt\u00e9rations) {
            this.m.setIteration_max(this.m.getIteration_max() * 2 + 1);
        } else if (arg0.getSource() == this.diminuerIt\u00e9rations) {
            this.m.setIteration_max(this.m.getIteration_max() / 2 + 1);
        }
        this.m.sety(0.0f);
    }
}

